/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class AssemblySourceFileFilter
implements FileFilter {
    private int[] tabStops = new int[]{10, 15};
    private int commentTabStop = 25;
    private String tabChars = "\t ";
    private String commentTabChars = ";";
    private String commentNoTabChars = "*";

    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(fileData.length);
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        int tabPosition = 0;
        int charPosition = 0;
        boolean noMoreTabs = false;
        for (int offset = 0; offset < fileData.length; ++offset) {
            char c = (char)(fileData[offset] & 0x7F);
            if (c == '\u0000') continue;
            if (c == '\r') {
                printWriter.println();
                tabPosition = 0;
                charPosition = 0;
                noMoreTabs = false;
                continue;
            }
            if (!noMoreTabs && this.tabChars.indexOf(c) > -1) {
                if (tabPosition >= this.tabStops.length) continue;
                int desiredPosition = this.tabStops[tabPosition];
                printWriter.print(' ');
                ++charPosition;
                while (charPosition < desiredPosition) {
                    printWriter.print(' ');
                    ++charPosition;
                }
                continue;
            }
            if (!noMoreTabs && this.commentTabChars.indexOf(c) > -1) {
                while (charPosition < this.commentTabStop) {
                    printWriter.print(' ');
                    ++charPosition;
                }
                printWriter.print(c);
                ++charPosition;
                continue;
            }
            if (charPosition == 0 && this.commentNoTabChars.indexOf(c) > -1) {
                noMoreTabs = true;
                printWriter.print(c);
                ++charPosition;
                continue;
            }
            printWriter.print(c);
            ++charPosition;
        }
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        String fileName = fileEntry.getFilename().trim();
        if (!fileName.toLowerCase().endsWith(".s")) {
            fileName = fileName + ".s";
        }
        return fileName;
    }
}

